c program cont_time
c calculates contact time for 2-d surface flow distribution
c
c standard input (unit 5):  
c         Tecplot file with nodal data, equidistant mesh
c
c standard output (unit 6):
c         mesh sizes
c         calculated age values for convergence monitoring
c         surface-averaged contact time
c
c output to unit 4:
c         Tecplot file conttime.dat with contact time distribution
c
c copyright:
c         creative commons CC BY 3.0
c         author: Karsten Fischer
c                 Becker Technologies GmbH, Eschborn, Germany
c version 1.0 of November 2013
c
c
c arrays for equidistant 20 x 20 cell mesh, staggered grid
c 
      parameter nx=21,ny=21
c nodal variables
      dimension x(nx,ny), y(nx,ny), u(nx,ny), v(nx,ny)
c cell variables
      dimension a(nx-1,ny-1), q(nx-1,ny-1), an(nx-1,ny-1)
c
c read mesh coordinates and velocities from standard input
c
      read (5,'(/////////)')
      do 10 j=1,ny
        do 10 i=1,nx
 10     read (5,*) x(i,j),y(i,j),u(i,j),v(i,j)
c
c calculate mesh sizes dx, dy
c
      dx=x(2,1)-x(1,1)
      dy=y(1,2)-y(1,1)
      write (6,*) dx,dy
c 
c calculate velocity divergence distribution q
c set initial value of age a = 0
c
      do 20 j=1,ny-1
        do 20 i=1,nx-1
        q(i,j)=-((u(i,j)+u(i,j+1))/2-(u(i+1,j)+u(i+1,j+1))/2)/dx-((v(i,
     -   j)+v(i+1,j))/2-(v(i,j+1)+v(i+1,j+1))/2)/dy
 20     a(i,j)=0.
c
c estimate time step dt and total time tm to keep courant number below 1
c
      um=-1.e6
      do 30 j=1,ny-1
        do 30 i=1,nx-1
        uloc=sqrt(((u(i,j)+u(i,j+1)+u(i+1,j)+u(i+1,j+1))/4)**2+((v(i,j)+
     -   v(i+1,j)+v(i,j+1)+v(i+1,j+1))/4)**2)
        um=max(um,uloc)
 30   continue
      tm=3*sqrt(((nx-1)*dx)**2+((ny-1)*dy)**2)/um
      dt=max(dx,dy)/um/2.
      write (6,*) um,tm,dt
c
c integrate differential equation for a over time until convergence
c 
      nt=2*tm/dt
      t=0.
      do 70 it=1,nt
        t=t+dt
c 
        do 40 j=1,ny-1
          do 40 i=1,nx-1
c u velocity on east cell side
          up=(u(i+1,j)+u(i+1,j+1))/2
c upwind value of a
          ap=0.
          if (up.gt.0.) then
            ap=a(i,j)
          else
            if (i.lt.nx-1) then
              ap=a(i+1,j)
            end if
          end if
c u velocity on west cell side
          um=(u(i,j)+u(i,j+1))/2
c upwind value of a
          am=0.
          if (um.lt.0.) then
            am=a(i,j)
          else
            if (i.gt.1) then
              am=a(i-1,j)
            end if
          end if
c advective term u da/dx
          udadx=(up*ap-um*am)/dx
c
c v velocity on north cell side
          vp=(v(i,j+1)+v(i+1,j+1))/2
c upwind value of a
          ap=0.
          if (vp.gt.0.) then
            ap=a(i,j)
          else
            if (j.lt.ny-1) then
              ap=a(i,j+1)
            end if
          end if
c v velocity on south cell side
          vm=(v(i,j)+v(i+1,j))/2
c upwind value of a
          am=0.
          if (vm.lt.0.) then
            am=a(i,j)
          else
            if (j.gt.1) then
              am=a(i,j-1)
            end if
          end if
c advective term v da/dy
          vdady=(vp*ap-vm*am)/dy
c explicit time step forward for new age an
          an(i,j)=a(i,j)+dt*(-udadx-vdady-abs(q(i,j))*a(i,j)+1)
 40     continue
c store new age in array a
        do 50 j=1,ny-1
          do 50 i=1,nx-1
          a(i,j)=an(i,j)
 50     continue
c
c write some values of a to standard output for convergence monitoring
c
        write (6,60) (a(i,4),i=1,10)
 60     format (1x,10f7.3)
 70   continue
c
c time integration finished
c
c write results in Tecplot format for postprocessing
c
      open (unit=4,file='conttime.dat',form='formatted')
c 
      nz=1
      write (4,'(''Title= ""'')')
      write (4,'(''variables= "x" "y" "a" "m"'')')
      write (4,'(''zone t="a" i = '',i3,'' j = '',i3,                   
     -  '' k = '',i3,'' DATAPACKING=BLOCK '',                           
     -  ''VARLOCATION = ([3-4]=CELLCENTERED)'')') nx,ny,nz
c
c mesh coordinates x, y
      do 80 ivar=1,2
c 
        do 80 j=1,ny
        do 80 i=1,nx
        if (ivar.eq.1) then
          write (4,'(1p3e11.3)') x(i,j)
        else if (ivar.eq.2) then
          write (4,'(1p3e11.3)') y(i,j)
        end if
 80   continue
c age a and cell index m
      do 90 ivar=3,4
        do 90 j=1,ny-1
        do 90 i=1,nx-1
        m=0
        if (abs(q(i,j)).lt.1.e-6) m=1
        if (ivar.eq.3) then
          write (4,'(1p4e11.3)') a(i,j)
        else
          write (4,'(i3)') m
        end if
 90   continue
      close (unit=4)
c 
c calculate surface average of 1/sqrt(a) for mass transfer coefficient
c 
      am=0.
      ac=0.
      eps=1.e-6
      do 100 j=1,ny-1
        do 100 i=1,nx-1
        if (abs(u(i,j)).gt.eps.or.abs(u(i+1,j)).gt.eps.or.abs(v(i,j))
     -   .gt.eps.or.abs(v(i,j+1)).gt.eps) then
          am=am+1/sqrt(a(i,j))
          ac=ac+1
        end if
 100  continue
      am=1/(am/ac)**2
c 
      write (6,*) ' average contact time: ',am
      stop
      end
